//+------------------------------------------------------------------+
//|                                                     Data WEB.mq5 |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property service
#property copyright "Daniel Jose"
#property version   "1.03"
//+------------------------------------------------------------------+
#include <Inner Channel.mqh>
//+------------------------------------------------------------------+
void OnStart()
{
	uDataServer loc1, loc2;
	
	while (!IsStopped())
	{
		if (!GlobalVariableCheck(def_GlobalValueInChannel))
		{
			GlobalVariableTemp(def_GlobalValueInChannel);
			GlobalVariableTemp(def_GlobalMaskInfo);
			GlobalVariableTemp(def_GlobalPositionInfos);
		}
		GlobalVariableGet(def_GlobalMaskInfo, loc1.value);
		GlobalVariableGet(def_GlobalPositionInfos, loc2.value);
		if (!_StopFlag)
		{
			GlobalVariableSet(def_GlobalValueInChannel, GetDataURL("https://tradingeconomics.com/stocks", 100, "<!doctype html>", 2, CharArrayToString(loc1.Info, 0, sizeof(uDataServer)), loc2.Position[0], loc2.Position[1], 0x0D));
			Sleep(1000);
		}
	}
	GlobalVariableSet(def_GlobalValueInChannel, Codification(def_MSG_FinishServer));
}
//+------------------------------------------------------------------+
double GetDataURL(const string url, const int timeout, const string szTest, int iTest, const string szFind, int iPos, int iInfo, char cLimit)
{
	string		headers, szInfo = "";
	char 			post[], charResultPage[];
	int			counter;
   
	if (WebRequest("GET", url, NULL, NULL, timeout, post, 0, charResultPage, headers) == -1) return Codification(def_MSG_FailedConnection);
	for (int c0 = 0, c1 = StringLen(szTest); (c0 < c1) && (!_StopFlag); c0++) if (szTest[c0] != charResultPage[iTest + c0]) return Codification(def_MSG_FailedReturn);
	for (int c0 = 0, c1 = StringLen(szFind); (c0 < c1) && (!_StopFlag); c0++) if (szFind[c0] != charResultPage[iPos + c0]) return Codification(def_MSG_FailedMask);
	if (_StopFlag) return Codification(def_MSG_FinishServer);
	for (counter = 0; charResultPage[counter + iInfo] == 0x20; counter++);
	for (;charResultPage[counter + iInfo] != cLimit; counter++) szInfo += CharToString(charResultPage[counter + iInfo]);
	
	return StringToDouble(szInfo);
}
//+------------------------------------------------------------------+
inline double Codification(const string arg)
{
	uDataServer loc;
	StringToCharArray(arg, loc.Info, 0, sizeof(uDataServer));
	
	return loc.value;
}
//+------------------------------------------------------------------+
